﻿using CE.Domain.DataObjects;
using CE.Domain.DataObjects.Sqlite;
using CE.Domain.DataObjects.Tables;
using CE.Domain.Inventory.DataObjects.Tables;
using System.Collections.Generic;

namespace CE.Domain.DataObjects.Inventory.Sqlite
{
	public class InventorySqliteDataConnection : GenericSqliteDataConnection
	{
		#region Constructor
		public InventorySqliteDataConnection()
		{

		}
		#endregion

		#region Protected Methods
		protected override void LoadSchemaImpl()
		{
			IList<ICreatableDomainTable> tables = new List<ICreatableDomainTable>();

			tables.Add(new InfoTable());
			tables.Add(new Box());
			tables.Add(new Room());
			tables.Add(new Location());
			tables.Add(new InventoryItem());

			foreach (ICreatableDomainTable table in tables)
				table.Create(DbConnection);
		}
		#endregion
	}
}
