﻿using CE.Support.Support;
using ServiceStack.DataAnnotations;

namespace CE.Domain.Inventory.DataObjects.Tables
{
	[Alias(InventoryTableNames.Box)]
	public class Box : InventoryTableBase, IEditLabeled
	{
		#region Constructor
		public Box() : base(InventoryTableNames.Box) { }
		#endregion

		#region Public Methods
		public override string ToString() => Label;
		#endregion

		#region Public Properties
		[Ignore]
		public override int TableTypeID => TableTypeId.Box;

		[AutoIncrement]
		[Required]
		[PrimaryKey]
		public override int Id { get; set; }

		[Required]
		[CustomField("TEXT")]
		public string Label { get; set; }
		#endregion
	}
}
