﻿using ServiceStack.DataAnnotations;

namespace CE.Domain.Inventory.DataObjects.Tables
{
	[Alias(InventoryTableNames.InventoryItem)]
	public class InventoryItem : InventoryTableBase
	{
		#region Constructor
		public InventoryItem() : base(InventoryTableNames.InventoryItem) { }
		#endregion

		#region Public Properties
		[Ignore]
		public override int TableTypeID => TableTypeId.InventoryItem;

		[AutoIncrement]
		[Required]
		[PrimaryKey]
		public override int Id { get; set; }

		[CustomField("TEXT")]
		[Default("")]
		public string Description { get; set; }

		[CustomField("TEXT")]
		[Default("")]
		public string Keyword1 { get; set;
		}
		[CustomField("TEXT")]
		[Default("")]
		public string Keyword2 { get; set;
		}
		[CustomField("TEXT")]
		[Default("")]
		public string Keyword3 { get; set; }

		[CustomField("TEXT")]
		[Default("")]
		public string Keyword4 { get; set; }

		[CustomField("TEXT")]
		[Default("")]
		public string Keyword5 { get; set; }

		[References(typeof(Location))]
		public int LocationId { get; set; }

		[References(typeof(Room))]
		public int RoomId { get; set;
		}
		[References(typeof(Box))]
		public int BoxId { get; set; }

		[Ignore]
		public Location Location { get; set; }

		[Ignore]
		public Room Room { get; set; }

		[Ignore]
		public Box Box { get; set; }
		#endregion

		#region Protected Methods
		protected override void InitializeFields()
		{
			AddField(InventoryFieldNames.Description, typeof(string), InventoryFieldLabelKeys.Description, string.Empty, this);
			AddField(InventoryFieldNames.Keyword1, typeof(string), InventoryFieldLabelKeys.Keyword1, string.Empty, this);
			AddField(InventoryFieldNames.Keyword2, typeof(string), InventoryFieldLabelKeys.Keyword2, string.Empty, this);
			AddField(InventoryFieldNames.Keyword3, typeof(string), InventoryFieldLabelKeys.Keyword3, string.Empty, this);
			AddField(InventoryFieldNames.Keyword4, typeof(string), InventoryFieldLabelKeys.Keyword4, string.Empty, this);
			AddField(InventoryFieldNames.Keyword5, typeof(string), InventoryFieldLabelKeys.Keyword5, string.Empty, this);
			AddField(InventoryFieldNames.RoomId, typeof(int), InventoryFieldLabelKeys.RoomId, 0, this);
			AddField(InventoryFieldNames.LocationId, typeof(int), InventoryFieldLabelKeys.LocationId, 0, this);
			AddField(InventoryFieldNames.BoxId, typeof(int), InventoryFieldLabelKeys.BoxId, 0, this);
		}
		#endregion
	}
}
