﻿using CE.Support.Support;
using ServiceStack.DataAnnotations;
using ServiceStack.OrmLite;
using System.Data;

namespace CE.Domain.Inventory.DataObjects.Tables
{
	public class Location : InventoryTableBase, IEditLabeled
	{
		#region Constructor
		public Location() : base(InventoryTableNames.Location) { }
		#endregion

		#region Public Methods
		public override string ToString() => Label;
		#endregion

		#region Public Properties
		[Ignore]
		public override int TableTypeID => TableTypeId.Location;

		[AutoIncrement]
		[Required]
		[PrimaryKey]
		public override int Id { get; set; }

		[CustomField("TEXT")]
		[Required]
		public string Label { get; set; }
		#endregion

		#region Protected Methods
		protected override void PostCreateTable(IDbConnection dbConnection)
		{
			dbConnection.Insert(new Location { Label = "Floor" });
			dbConnection.Insert(new Location { Label = "Closet" });
			dbConnection.Insert(new Location { Label = "Cabinet" });
		}
		#endregion
	}
}
