﻿using CE.Support.Support;
using ServiceStack.DataAnnotations;
using ServiceStack.OrmLite;
using System.Data;

namespace CE.Domain.Inventory.DataObjects.Tables
{
	public class Room : InventoryTableBase, IEditLabeled
	{
		#region Constructor
		public Room() : base(InventoryTableNames.Room) { }
		#endregion

		#region Public Methods
		public override string ToString() => Label;
		#endregion

		#region Public Properties
		[Ignore]
		public override int TableTypeID => TableTypeId.Room;

		[AutoIncrement]
		[Required]
		[PrimaryKey]
		public override int Id { get; set; }

		[CustomField("TEXT")]
		[Required]
		public string Label { get; set; }
		#endregion

		#region Protected Methods
		protected override void PostCreateTable(IDbConnection dbConnection)
		{
			dbConnection.Insert(new Room { Label = "Office" });
			dbConnection.Insert(new Room { Label = "Guest" });
			dbConnection.Insert(new Room { Label = "Master" });
			dbConnection.Insert(new Room { Label = "Kitchen" });
			dbConnection.Insert(new Room { Label = "Garage" });
			dbConnection.Insert(new Room { Label = "Storeroom" });
		}
		#endregion
	}
}
