﻿using NUnit.Framework;

namespace CE.Domain.Inventory.Test
{
    public abstract class InventoryDomainTestFixtureBase
    {
		#region Constructor
		public InventoryDomainTestFixtureBase()
		{

		}
		#endregion

		#region Initialize/Cleanup
		[SetUp]
		public void Initialize()
		{
			InitializeLicense();
			InitializeImpl();
		}
		[TearDown]
		public void Cleanup()
		{
			CleanupImpl();
		}
		#endregion

		#region Protected Methods
		protected virtual void InitializeImpl() {  }
		protected virtual void CleanupImpl() {  }
		protected void InitializeLicense() {  }
		#endregion

		#region Protected Properties
		protected IRepositoryDataSource DataSource { get; set; }
		protected string Filename { get; set; }
		#endregion
	}
}
