﻿using CE.Domain.Inventory.DataObjects.Tables;
using CE.Domain.Inventory.ModelingObjects;
using CE.Domain.ModelingObjects;
using FluentAssertions;
using NUnit.Framework;
using System.IO;

namespace CE.Domain.Inventory.Test.ModelingObjects
{
	[TestFixture]
	public class CrudTestFixture : InventoryDomainTestFixtureBase
	{
		#region Constructor
		public CrudTestFixture()
		{

		}
		#endregion

		#region Tests
		[Test]
		public void Test_C_In_CRUD()
		{
			using (DataSource dataSource = new InventoryDataSource())
			{
				Filename = Path.GetTempFileName();
				File.Delete(Filename);
				File.Exists(Filename).Should().BeFalse();

				dataSource.New(Filename);
				dataSource.IsOpen().Should().BeTrue();

				ITableRepository<Box> boxRepository = dataSource.DataRepository.GetTableRepositoryFor<Box>(InventoryTableNames.Box);
				boxRepository.Should().NotBeNull();

				Box box = new Box { Label = "A1" };
				boxRepository.Save(box);
				box.Id.Should().NotBe(0);

				ITableRepository<Room> roomRepository = dataSource.DataRepository.GetTableRepositoryFor<Room>(InventoryTableNames.Room);
				roomRepository.Should().NotBeNull();

				Room kitchen = roomRepository.Find(r => r.Label == "Kitchen");
				kitchen.Should().NotBeNull("Kitchen not found");

				ITableRepository<Location> locationRepository = dataSource.DataRepository.GetTableRepositoryFor<Location>(InventoryTableNames.Location);
				locationRepository.Should().NotBeNull();

				Location floor = locationRepository.Find(l => l.Label == "Floor");

				InventoryItem item = new InventoryItem
				{
					Description = "Test1",
					Keyword1 = "1",
					Keyword2 = "2",
					Keyword3 = "3",
					Keyword4 = "4",
					Keyword5 = "5",
					Location = floor,
					Room = kitchen,
				};

				ITableRepository<InventoryItem> inventoryRepository = dataSource.DataRepository.GetTableRepositoryFor<InventoryItem>(InventoryTableNames.InventoryItem);
				inventoryRepository.Should().NotBeNull();

				inventoryRepository.Save(item);
				item.Id.Should().NotBe(0);

				InventoryItem newItem = inventoryRepository[item.Id];
				newItem.Should().NotBeNull();

				newItem.Should().NotBeSameAs(item);
			}
		}
		[Test]
		public void Test_R_In_CRUD()
		{
			using (DataSource dataSource = new InventoryDataSource())
			{
				Filename = Path.GetTempFileName();
				File.Delete(Filename);
				File.Exists(Filename).Should().BeFalse();

				dataSource.New(Filename);
				dataSource.IsOpen().Should().BeTrue();

				ITableRepository<Box> boxRepository = dataSource.DataRepository.GetTableRepositoryFor<Box>(InventoryTableNames.Box);
				boxRepository.Should().NotBeNull();

				Box box = new Box { Label = "A1" };
				boxRepository.Save(box);
				box.Id.Should().NotBe(0);

				ITableRepository<Room> roomRepository = dataSource.DataRepository.GetTableRepositoryFor<Room>(InventoryTableNames.Room);
				roomRepository.Should().NotBeNull();

				Room kitchen = roomRepository.Find(r => r.Label == "Kitchen");
				kitchen.Should().NotBeNull("Kitchen not found");

				ITableRepository<Location> locationRepository = dataSource.DataRepository.GetTableRepositoryFor<Location>(InventoryTableNames.Location);
				locationRepository.Should().NotBeNull();

				Location floor = locationRepository.Find(l => l.Label == "Floor");

				InventoryItem item = new InventoryItem
				{
					Description = "Test1",
					Keyword1 = "1",
					Keyword2 = "2",
					Keyword3 = "3",
					Keyword4 = "4",
					Keyword5 = "5",
					Location = floor,
					Room = kitchen,
				};

				ITableRepository<InventoryItem> inventoryRepository = dataSource.DataRepository.GetTableRepositoryFor<InventoryItem>(InventoryTableNames.InventoryItem);
				inventoryRepository.Should().NotBeNull();

				inventoryRepository.Save(item);
				item.Id.Should().NotBe(0);

				InventoryItem newItem = inventoryRepository[item.Id];
				newItem.Should().NotBeNull();

				newItem.Should().NotBeSameAs(item);

				((IInventoryDataRepository)dataSource.DataRepository).InventoryItemManager.Should().NotBeNull();
			}
		}
		#endregion
	}
}
