﻿using CE.Domain.DataObjects.Sqlite;
using CE.Domain.Inventory.DataObjects.Tables;
using CE.Domain.Inventory.ModelingObjects;
using CE.Domain.ModelingObjects;
using FluentAssertions;
using NUnit.Framework;
using ServiceStack.OrmLite;
using System.IO;

namespace CE.Domain.Inventory.Test.ModelingObjects
{
	[TestFixture]
	public class InventoryDataSourceTestFixture : InventoryDomainTestFixtureBase
	{
		#region Constructor
		public InventoryDataSourceTestFixture()
		{

		}
		#endregion

		#region Tests
		[Test]
		public void TestNewDatabase()
		{
			using (DataSource dataSource = new InventoryDataSource())
			{
				Filename = Path.GetTempFileName();
				File.Delete(Filename);
				File.Exists(Filename).Should().BeFalse();

				dataSource.New(Filename);
				dataSource.IsOpen().Should().BeTrue();

				ISqliteDataConnection dataConnection = dataSource.GetDataConnection();

				dataConnection.DbConnection.TableExists<Box>().Should().BeTrue();
				dataConnection.DbConnection.TableExists<Room>().Should().BeTrue();
				dataConnection.DbConnection.TableExists<Location>().Should().BeTrue();
				dataConnection.DbConnection.TableExists<InventoryItem>().Should().BeTrue();

				dataSource.Close();
				File.Exists(Filename).Should().BeTrue();
				File.Delete(Filename);
				File.Exists(Filename).Should().BeFalse();
			}
		}
		#endregion
	}
}
