﻿using CE.Domain.Inventory.DataObjects.Tables;
using CE.Domain.ModelingObjects.Support;
using System.Collections;

namespace CE.Domain.Inventory.ModelingObjects
{
	public class BoxManager : DomainTableManagerBase<Box>
	{
		#region Constructor
		public BoxManager(ITableRepository<Box> tableRepository)
			: base(tableRepository)
		{

		}
		#endregion

		#region Public Methods
		public override IList GetList()
		{
			return new ArrayList((ICollection)IDs());
		}
		#endregion

		#region Protected Methods
		protected override Box NewElement(params object[] args)
		{
			return new Box();
		}
		protected override void InitializeFields()
		{
			AddField(InventoryFieldNames.Label, typeof(string), InventoryFieldLabelKeys.Label, string.Empty);
		}
		#endregion
	}
}
