﻿using CE.Domain.DataObjects.Sqlite;
using CE.Domain.Inventory.DataObjects.Tables;
using CE.Domain.Inventory.ModelingObjects.Repositories;
using CE.Domain.ModelingObjects;

namespace CE.Domain.Inventory.ModelingObjects
{
	public class InventoryDataRepository : DataRepository, IInventoryDataRepository
	{
		#region Constructor
		public InventoryDataRepository(ISqliteDataConnection dataConnection)
			: base(dataConnection)
		{

		}
		#endregion

		#region Public Properties
		public InventoryItemManager InventoryItemManager => _inventoryItemManager
			?? (_inventoryItemManager = new InventoryItemManager(GetTableRepositoryFor<InventoryItem>(InventoryTableNames.InventoryItem)));

		public RoomManager RoomManager => _roomManager
			?? (_roomManager = new RoomManager(GetTableRepositoryFor<Room>(InventoryTableNames.Room)));

		public LocationManager LocationManager => _locationManager 
			?? (_locationManager = new LocationManager(GetTableRepositoryFor<Location>(InventoryTableNames.Location)));

		public BoxManager BoxManager => _boxManager
			?? (_boxManager = new BoxManager(GetTableRepositoryFor<Box>(InventoryTableNames.Box)));
		#endregion

		#region Protected Methods
		protected override IRepositoryFactory NewRepositoryFactory() => new InventoryDataRepositoryFactory(this);
		#endregion

		#region Private Fields
		private InventoryItemManager _inventoryItemManager;
		private BoxManager _boxManager;
		private RoomManager _roomManager;
		private LocationManager _locationManager;
		#endregion
	}
}
