﻿using System;
using CE.Domain.DataObjects;
using CE.Domain.Inventory.DataObjects.Tables;
using ServiceStack.Model;

namespace CE.Domain.Inventory.ModelingObjects
{
	public class InventoryFilter : EditableElementBase, IHasId<int>
	{
		#region Constructor
		public InventoryFilter()
		{
			Room = new Room();
			Location = new Location();
			Box = new Box();
		}
		#endregion

		#region Public Methods
		public bool CheckAll(InventoryItem item)
		{
			bool ok = false;

			if (FilterDescription && ContainsKeyword(item, Description))
				ok = true;
			else if (FilterKeyword1 && ContainsKeyword(item, Keyword1))
				ok = true;
			else if (FilterKeyword2 && ContainsKeyword(item, Keyword2))
				ok = true;
			else if (FilterKeyword3 && ContainsKeyword(item, Keyword3))
				ok = true;
			else if (FilterKeyword4 && ContainsKeyword(item, Keyword4))
				ok = true;
			else if (FilterKeyword5 && ContainsKeyword(item, Keyword5))
				ok = true;
			else if (FilterRoom && item.Room.Id == Room.Id)
				ok = true;
			else if (FilterLocation && item.Location.Id == Location.Id)
				ok = true;
			else if (FilterBox && item.Box.Id == Box.Id)
				ok = true;
			else
			{
				if (!FilterDescription && !FilterKeyword1 && !FilterKeyword2 &&
					!FilterKeyword3 && !FilterKeyword4 && !FilterKeyword5 &&
					!FilterRoom && !FilterLocation && !FilterBox)
					ok = true;
			}


			return ok;
		}

		private bool ContainsKeyword(InventoryItem item, string keyword)
		{
			bool found = false;
			if (!string.IsNullOrEmpty(item.Description) &&
				item.Description.ToLower().Contains(keyword.ToLower()))
				found = true;
			if (!string.IsNullOrEmpty(item.Keyword1) &&
				item.Keyword1.ToLower().Contains(keyword.ToLower()))
				found = true;
			if (!string.IsNullOrEmpty(item.Keyword2) &&
				item.Keyword2.ToLower().Contains(keyword.ToLower()))
				found = true;
			if (!string.IsNullOrEmpty(item.Keyword3) &&
				item.Keyword3.ToLower().Contains(keyword.ToLower()))
				found = true;
			if (!string.IsNullOrEmpty(item.Keyword4) &&
				item.Keyword4.ToLower().Contains(keyword.ToLower()))
				found = true;
			if (!string.IsNullOrEmpty(item.Keyword5) &&
				item.Keyword5.ToLower().Contains(keyword.ToLower()))
				found = true;

			return found;
		}
		#endregion

		#region Public Properties
		public int Id
		{
			get;
			set;
		}
		public bool FilterDescription
		{
			get;
			set;
		}
		public string Description
		{
			get;
			set;
		}
		public bool FilterKeyword1
		{
			get;
			set;
		}
		public string Keyword1
		{
			get;
			set;
		}

		public bool FilterKeyword2
		{
			get;
			set;
		}
		public string Keyword2
		{
			get;
			set;
		}

		public bool FilterKeyword3
		{
			get;
			set;
		}
		public string Keyword3
		{
			get;
			set;
		}

		public bool FilterKeyword4
		{
			get;
			set;
		}
		public string Keyword4
		{
			get;
			set;
		}

		public bool FilterKeyword5
		{
			get;
			set;
		}
		public string Keyword5
		{
			get;
			set;
		}
		public bool FilterRoom
		{
			get;
			set;
		}
		public Room Room
		{
			get;
			set;
		}
		public bool FilterLocation
		{
			get;
			set;
		}
		public Location Location
		{
			get;
			set;
		}
		public bool FilterBox
		{
			get;
			set;
		}
		public Box Box
		{
			get;
			set;
		}
		#endregion

		#region Protected Methods
		protected override void InitializeFields()
		{
			AddField(InventoryFieldNames.FilterDescription, typeof(bool), InventoryFieldLabelKeys.FilterDescription, false, this);
			AddField(InventoryFieldNames.Description, typeof(string), InventoryFieldLabelKeys.Description, string.Empty, this);

			AddField(InventoryFieldNames.FilterKeyword1, typeof(bool), InventoryFieldLabelKeys.FilterKeyword1, false, this);
			AddField(InventoryFieldNames.Keyword1, typeof(string), InventoryFieldLabelKeys.Keyword1, string.Empty, this);

			AddField(InventoryFieldNames.FilterKeyword2, typeof(bool), InventoryFieldLabelKeys.FilterKeyword2, false, this);
			AddField(InventoryFieldNames.Keyword2, typeof(string), InventoryFieldLabelKeys.Keyword2, string.Empty, this);

			AddField(InventoryFieldNames.FilterKeyword3, typeof(bool), InventoryFieldLabelKeys.FilterKeyword3, false, this);
			AddField(InventoryFieldNames.Keyword3, typeof(string), InventoryFieldLabelKeys.Keyword3, string.Empty, this);

			AddField(InventoryFieldNames.FilterKeyword4, typeof(bool), InventoryFieldLabelKeys.FilterKeyword4, false, this);
			AddField(InventoryFieldNames.Keyword4, typeof(string), InventoryFieldLabelKeys.Keyword4, string.Empty, this);

			AddField(InventoryFieldNames.FilterKeyword5, typeof(bool), InventoryFieldLabelKeys.FilterKeyword5, false, this);
			AddField(InventoryFieldNames.Keyword5, typeof(string), InventoryFieldLabelKeys.Keyword5, string.Empty, this);

			AddField(InventoryFieldNames.FilterRoom, typeof(bool), InventoryFieldLabelKeys.FilterRoom, false, this);
			AddField(InventoryFieldNames.Room, typeof(Room), InventoryFieldLabelKeys.Room, new Room(), this);

			AddField(InventoryFieldNames.FilterLocation, typeof(bool), InventoryFieldLabelKeys.FilterLocation, false, this);
			AddField(InventoryFieldNames.Location, typeof(Location), InventoryFieldLabelKeys.Location, new Location(), this);

			AddField(InventoryFieldNames.FilterBox, typeof(bool), InventoryFieldLabelKeys.FilterBox, false, this);
			AddField(InventoryFieldNames.Box, typeof(Box), InventoryFieldLabelKeys.Box, new Box(), this);
		}
		#endregion
	}
}
