﻿using CE.Domain.Inventory.DataObjects.Tables;
using CE.Domain.Inventory.ModelingObjects.Repositories;
using CE.Domain.ModelingObjects.Support;
using System;
using System.Collections;
using System.Collections.Generic;

namespace CE.Domain.Inventory.ModelingObjects
{
	public class InventoryItemManager : DomainTableManagerBase<InventoryItem>
	{
		#region Constructor
		public InventoryItemManager(ITableRepository<InventoryItem> tableRepository)
			: base(tableRepository)
		{

		}
		#endregion

		#region Public Methods
		public override IList GetList()
		{
			return new ArrayList((ICollection)IDs());
		}
		public void ApplyFilter(InventoryFilter filter)
		{
			//Reset the filtered items to null. If filter is not null, apply the filter
			FilteredInventory = null;
			if (filter != null)
				FilteredInventory = InventoryItemRepository.LoadItems(filter);
			ReQuery();
		}
		#endregion

		#region Protected Methods
		protected override List<InventoryItem> LoadItems()
		{
			if (FilteredInventory != null)
				return FilteredInventory;

			return TableRepository.LoadItems();
		}
		protected override InventoryItem NewElement(params object[] args)
		{
			return new InventoryItem();
		}
		protected override void InitializeFields()
		{
			AddField(InventoryFieldNames.Description, typeof(string), InventoryFieldLabelKeys.Description, string.Empty);
			AddField(InventoryFieldNames.Keyword1, typeof(string), InventoryFieldLabelKeys.Keyword1, string.Empty);
			AddField(InventoryFieldNames.Keyword2, typeof(String), InventoryFieldLabelKeys.Keyword2, string.Empty);
			AddField(InventoryFieldNames.Keyword3, typeof(String), InventoryFieldLabelKeys.Keyword3, string.Empty);
			AddField(InventoryFieldNames.Keyword4, typeof(String), InventoryFieldLabelKeys.Keyword4, string.Empty);
			AddField(InventoryFieldNames.Keyword5, typeof(String), InventoryFieldLabelKeys.Keyword5, string.Empty);
			AddField(InventoryFieldNames.LocationId, typeof(int), InventoryFieldLabelKeys.LocationId, 0);
			AddField(InventoryFieldNames.RoomId, typeof(int), InventoryFieldLabelKeys.RoomId, 0);
			AddField(InventoryFieldNames.BoxId, typeof(int), InventoryFieldLabelKeys.BoxId, 0);

			AddField(InventoryFieldNames.Location, typeof(Location), InventoryFieldLabelKeys.Location, new Location());
			AddField(InventoryFieldNames.Room, typeof(Room), InventoryFieldLabelKeys.Room, new Room());
			AddField(InventoryFieldNames.Box, typeof(Box), InventoryFieldLabelKeys.Box, new Box());
		}
		#endregion

		#region Private Properties
		private List<InventoryItem> FilteredInventory
		{
			get;
			set;
		}
		private InventoryItemRepository InventoryItemRepository
		{
			get { return TableRepository as InventoryItemRepository;  }
		}
		#endregion
	}
}
