﻿using CE.Domain.Inventory.DataObjects.Tables;
using CE.Domain.ModelingObjects.Support;
using System.Collections;

namespace CE.Domain.Inventory.ModelingObjects
{
	public class LocationManager : DomainTableManagerBase<Location>
	{
		#region Constructor
		public LocationManager(ITableRepository<Location> tableRepository)
			: base(tableRepository)
		{

		}
		#endregion

		#region Public Methods
		public override IList GetList()
		{
			return new ArrayList((ICollection)IDs());
		}
		#endregion

		#region Protected Methods
		protected override Location NewElement(params object[] args)
		{
			return new Location();
		}
		protected override void InitializeFields()
		{
			AddField(InventoryFieldNames.Label, typeof(string), InventoryFieldLabelKeys.Label, string.Empty);
		}
		#endregion
	}
}
