﻿using CE.Domain.DataObjects.Sqlite;
using CE.Domain.ModelingObjects.Repositories;

namespace CE.Domain.Inventory.ModelingObjects.Repositories
{
	public class InventoryDataRepositoryFactory : RepositoryFactory
	{
		#region Constructor
		public InventoryDataRepositoryFactory(IDataRepository dataRepository)
			: base(dataRepository)
		{

		}
		#endregion

		#region Public Methods
		public override ITableRepository<TTableType> CreateRepository<TTableType>(string name, ISqliteDataConnection dataConnection)
		{
			switch (name)
			{
				case InventoryTableNames.InventoryItem:
					return (ITableRepository<TTableType>)(new InventoryItemRepository(dataConnection, DataRepository));
				default:
					return base.CreateRepository<TTableType>(name, dataConnection);
			}
		}
		#endregion
	}
}
